import pandas as pd   
import pickle
import matplotlib.pyplot as plt

# Load the dataset
laptops_price = pd.read_csv("laptops_price.csv")

# Define powerful CPUs (you can modify the list based on the desired CPUs)
powerful_cpus = [
 "Intel Core i7", "Intel Core i9", "AMD Ryzen 7", "AMD Ryzen 9"
]
 
# Create a boolean mask for powerful CPUs
filtered_laptops["Powerful_CPU"] = filtered_laptops["CPU"].apply(lambda x: any(cpu in x for cpu in powerful_cpus))
 
# Filter the dataset for powerful CPUs and at least 8GB of RAM
powerful_laptops = filtered_laptops[(filtered_laptops["Powerful_CPU"]) & (filtered_laptops["RAM"].str.replace("GB", "").astype(int) >= 8)]
 
# Count the number of laptops by manufacturer
laptop_counts = powerful_laptops["Manufacturer"].value_counts()
 
# Create a bar chart of the distribution of laptops with a powerful CPU and at least 8GB of RAM
plt.figure(figsize=(10, 6))
laptop_counts.plot(kind="bar")
plt.title("Distribution of Laptops with Powerful CPU and at least 8GB RAM")
plt.xlabel("Manufacturer")
plt.ylabel("Number of Laptops")
plt.show()

print(laptop_counts)
pickle.dump(laptop_counts,open("./ref_result/laptop_counts.pkl","wb"))

plt.savefig('./ref_result/powerful_laptops_distribution.png')
plt.show()
